# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 4
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR4_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR4(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    current_round = len(my_history) + 1  # 1-based index
    
    # Check if opponent's code has hard-coded defection
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Early rounds (1-4): Tit-for-Tat
    if current_round <= 4:
        return opp_history[-1]
    
    # Mid rounds (5-7): Test opponent's tolerance
    if 5 <= current_round <= 7:
        if current_round == 5:
            # Check if opponent was mostly cooperative in first 4 rounds
            if opp_history[:4].count("C") >= 3:
                return "D"
            else:
                return opp_history[-1]
        elif current_round == 7:
            # If opponent didn't retaliate after our defection in round 5, defect again
            if len(my_history) >= 5 and my_history[4] == "D" and opp_history[4] == "C":
                return "D"
            else:
                return opp_history[-1]
        else:
            return opp_history[-1]
    
    # Late rounds (8-10): Exploit if opponent is tolerant, else Tit-for-Tat
    if current_round >= 8:
        # Check if opponent didn't retaliate after our defection in round 5 or 7
        if (len(my_history) >= 5 and my_history[4] == "D" and opp_history[4] == "C") or \
           (len(my_history) >= 7 and my_history[6] == "D" and opp_history[6] == "C"):
            return "D"
        else:
            return opp_history[-1]
    
    return "C"